# docker image 操作(4): 移除镜像

一个Docker 镜像(image)包含了程序代码和程序运行所依赖的所有环境。
Docker 镜像一般存放在镜像仓库服务(Image Registry)里，默认的镜像仓库服务是Docker Hub。
用户可以制作、构建镜像、将镜像上传到镜像仓库服务，从而可以在其他地方从镜像仓库服务里拉取镜像。

通过命令`docker image rm`命令可以删除不用的镜像，例如先通过命令查看有哪些镜像。

```bash
docker image ls
```

截图如下，可以看到两个名字为`<none>`的镜像：

![](./docker-image-rm-ls.png)

如果镜像没有被启动过，直接之下下面的命令能删除成功：

```bash
docker image rm 09d01ed9156b
```

如图所示：

![](./docker-image-rm-success.png)

但是如果镜像被启动过，有可能出现错误信息：

![](./docker-image-rm-failed.png)

红框的提示表示该镜像被启动过并且目前处于停止状态，我们可以通过`docker ps`命令查看被启动过的镜像状态

![](./docker-image-rm-ps.png)

可以看到，其中

* 横向的红框是ID为`09d01ed9156b`的镜像启动后的`container`（参考下一节）的状态
* 纵向的红框是所有启动的`container`的当前状态，可以看到图里的都处于`Exited`的退出状态。

因此我们可以批量使用Linux命令批量删除

```bash
docker ps -a | grep "Exited" | awk '{print $1 }'|xargs docker rm
```

如图所示

![](./docker-image-rm-clear.png)

以下说法错误的是？

## 答案

无论镜像是否启动都可以直接使用命令`docker image rm`直接删除成功

## 选项

### A

使用命令`docker image rm` 移除镜像时，可能因为镜像已经被启动过而失败

### B

可以使用`docker ps`命令查看已启动镜像状态，获得某个镜像的`container`对应的ID

### C

可以使用`docker rm {container id}`移除已启动镜像的`container`
